function y = broyden ( F, J, x0, TOL, Nmax ) 


Fold = feval(F,x0)'; 
Jold = feval(J,x0); 
A0 = inv ( Jold ); 
dx = -A0 * Fold; 
x0   = x0 + dx; 
if ( nargout == 0 ) 
          disp ( x0' ) 
end 


for i = 2 : Nmax 
     Fnew = feval(F,x0)'; 
          dy = Fnew - Fold; 
          u = A0 * dy; 
          v = dx' * A0; 
          denom = dx' * u; 
          A0 = A0 + ( dx - u ) * v / denom; 
          dx = -A0 * Fnew; 
              x0 = x0 + dx; 

     if ( nargout == 0 ) 
              disp ( x0' ) 
          end 

     if ( max(abs(dx)) < TOL ) 
              if ( nargout == 1 ) 
                  y = x0; 
              end 
              return 
          else 
              Fold = Fnew; 
          end 

end 

disp('broyden error: Maximum number of iterations exceeded'); 
if ( nargout == 1 ) y = x0; end; 
